global dataset ndhs // apis or ndhs

use "$data\/${dataset}file", clear

	if "$dataset"=="ndhs" {
		global var phic
		global label "Covered by PHIC"
	}
	
	if strpos("$dataset","apis")==1 {
		global var phic
		global label "Primary Member of PHIC"
		
		*Manually remove "A.APIS" title
		*global var lnpchealth
		*global label "Log Medical Expenditures"		
	}

	*Lowess options
	global option 
	*restriction
	global restrict inrange(age,20,80)  
	*tag to name file if special sample
	global type 


if strpos("$dataset","apis")==1 {
	*****************************************************
	*APIS
	*****************************,************************
	
	preserve 
	  collapse (mean) $var /*[aw=mem_rfact]*/, by(age year) 
	  twoway ///
		 (lowess $var age if age>=60, ms(i) lc(gs3) $option) ///
		 (lowess $var age if age<=60, ms(i) lc(gs3) $option) ///
		 (scatter $var age, ms(Oh) mc(gs0)) ///
		 ///
		 if $restrict ///
		 , ///
		 by(year, legend(off) graphr(color(white)) note("") title("A. APIS")) ///
		 xline(60, lp(dash) lc(gs12)) ///
		 xtitle("Age") ytitle("$label") ylabel(, nogrid) ///
		 subtitle(, bcolor(white)) 
		 
		 graph export "$figs\apis_RD_${var}${type}.png", replace width(2000)
	restore
}

if "$dataset"=="ndhs" {
	*****************************************************
	*NDHS
	*****************************************************

	preserve 
	  collapse (mean) phicmem [aw=hv005], by(age year) 
	  twoway ///
		 (lowess phicmem age if age>=60, ms(i) lc(gs3) $option) ///
		 (lowess phicmem age if age<=60, ms(i) lc(gs3) $option) ///
		 (scatter phicmem age, ms(Oh) mc(gs0)) ///
		 ///
		 if $restrict ///
		 , ///
		 by(year, legend(off) graphr(color(white)) note("") title("B. DHS")) ///
		 xline(60, lp(dash) lc(gs12)) ///
		 xtitle("Age") ytitle("$label") ylabel(, nogrid) ///
		 subtitle(, bcolor(white)) 
		 graph export "$figs\dhs_RD_${var}${type}.png", replace width(2000)
	restore
	

		
}
